/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockSetTypeBuilder
extends BaseBuilder<BlockSetType, BlockSetTypeBuilder> {
    private ResourceLocation soundType;
    private ResourceLocation doorClose;
    private ResourceLocation doorOpen;
    private ResourceLocation trapdoorClose;
    private ResourceLocation trapdoorOpen;
    private ResourceLocation pressurePlateOff;
    private ResourceLocation pressurePlateOn;
    private ResourceLocation buttonOff;
    private ResourceLocation buttonOn;
    private boolean isWood;
    private ResourceLocation hangingSignSoundType;
    private ResourceLocation fenceGateClose;
    private ResourceLocation fenceGateOpen;
    private boolean canOpenByHand = true;

    public static BlockSetTypeBuilder begin(ThingParser<BlockSetTypeBuilder> ownerParser, ResourceLocation registryName) {
        return new BlockSetTypeBuilder(ownerParser, registryName);
    }

    private BlockSetTypeBuilder(ThingParser<BlockSetTypeBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    public void setSoundType(ResourceLocation resourceLocation) {
        this.soundType = resourceLocation;
    }

    public void setDoorClose(ResourceLocation resourceLocation) {
        this.doorClose = resourceLocation;
    }

    public void setDoorOpen(ResourceLocation resourceLocation) {
        this.doorOpen = resourceLocation;
    }

    public void setTrapdoorClose(ResourceLocation resourceLocation) {
        this.trapdoorClose = resourceLocation;
    }

    public void setTrapdoorOpen(ResourceLocation resourceLocation) {
        this.trapdoorOpen = resourceLocation;
    }

    public void setPressurePlateOff(ResourceLocation resourceLocation) {
        this.pressurePlateOff = resourceLocation;
    }

    public void setPressurePlateOn(ResourceLocation resourceLocation) {
        this.pressurePlateOn = resourceLocation;
    }

    public void setButtonOff(ResourceLocation resourceLocation) {
        this.buttonOff = resourceLocation;
    }

    public void setButtonOn(ResourceLocation resourceLocation) {
        this.buttonOn = resourceLocation;
    }

    public void setIsWood(boolean b) {
        this.isWood = b;
    }

    public void setHangingSignSoundType(ResourceLocation resourceLocation) {
        this.hangingSignSoundType = resourceLocation;
    }

    public void setFenceGateClose(ResourceLocation resourceLocation) {
        this.fenceGateClose = resourceLocation;
    }

    public void setFenceGateOpen(ResourceLocation resourceLocation) {
        this.fenceGateOpen = resourceLocation;
    }

    public void setCanOpenByHand(boolean b) {
        this.canOpenByHand = b;
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Block Set Type";
    }

    @Override
    protected BlockSetType buildInternal() {
        SoundType soundTypeObj = Utils.getOrElse(ThingRegistries.SOUND_TYPES, this.soundType, SoundType.f_56736_);
        SoundEvent doorCloseEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.doorClose, SoundEvents.f_12626_);
        SoundEvent doorOpenEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.doorOpen, SoundEvents.f_12627_);
        SoundEvent trapdoorCloseEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.trapdoorClose, SoundEvents.f_12628_);
        SoundEvent trapdoorOpenEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.trapdoorOpen, SoundEvents.f_12629_);
        SoundEvent pressurePlateOffEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.pressurePlateOff, SoundEvents.f_12636_);
        SoundEvent pressurePlateOnEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.pressurePlateOn, SoundEvents.f_12637_);
        SoundEvent buttonOffEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.buttonOff, SoundEvents.f_12631_);
        SoundEvent buttonOnEvent = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.buttonOn, SoundEvents.f_12632_);
        return new BlockSetType(this.getRegistryName().toString(), this.canOpenByHand, soundTypeObj, doorCloseEvent, doorOpenEvent, trapdoorCloseEvent, trapdoorOpenEvent, pressurePlateOffEvent, pressurePlateOnEvent, buttonOffEvent, buttonOnEvent);
    }

    public boolean isWood() {
        return this.isWood;
    }

    public WoodType buildWoodType(BlockSetType setType) {
        SoundType hangingSignSoundType = Utils.getOrElse(ThingRegistries.SOUND_TYPES, this.pressurePlateOn, SoundType.f_244174_);
        SoundEvent fenceGateClose = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.fenceGateClose, SoundEvents.f_11872_);
        SoundEvent fenceGateOpen = Utils.getOrElse(ForgeRegistries.SOUND_EVENTS, this.fenceGateOpen, SoundEvents.f_11873_);
        return new WoodType(this.getRegistryName().toString(), setType, setType.f_271136_(), hangingSignSoundType, fenceGateClose, fenceGateOpen);
    }
}

